/*
################################################################################
#                                                                              #
#    Ambient Lights Controller Firmware                                        #
#                                                                              #
#    Copyright 2012 Robert Mai                                                 #
#                                                                              #
#    Contact: robert@hsapps.com                                                #
#    URL:     http://www.hsapps.com                                            #
#                                                                              #
#                                                                              #
#    Ambient Lights Controller Firmware is free software: you can              #
#    redistribute it and/or modify it under the terms of the GNU General       #
#    Public License as published by the Free Software Foundation, either       #
#    version 3 of the License, or (at your option) any later version.          #
#                                                                              #
#    Ambient Lights Controller Firmware is distributed in the hope that        #
#    it will be useful, but WITHOUT ANY WARRANTY; without even the implied     #
#    warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.          #
#    See the GNU General Public License for more details.                      #
#                                                                              #
#    You should have received a copy of the GNU General Public License         #
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.     #
#                                                                              #
################################################################################
*/

#ifndef SerialMessageInterface_h
#define SerialMessageInterface_h

#include "Arduino.h"
#include "StateMachine.h"
#include "LEDController.h"
//#include <ASKModulator.h>
#include <MyHomeMessageLayer.h>

class SerialMessageInterface
{
  private:
    StateMachine* sm1;
    LEDController* led1;
    StateMachine* sm2;
    LEDController* led2;
    MessageReader reader;
    MessageWriter writer;
    Message* statusMsg;
    boolean continuousUpdateCh1;
    boolean continuousUpdateCh2;
    unsigned long nextContinuousUpdate;
    unsigned long updateInterval;
//    ASKModulator* askMod;
    void printMessage(Message* msg);
    void processMessage(Message* msg);
    void sendStatusMessage(int channelNumber, StateMachine* sm, LEDController* led);
  public:
    SerialMessageInterface();
    void setup(int baudRate, StateMachine* vSm1, LEDController* vLed1, StateMachine* vSm2, LEDController* vLed2); //, ASKModulator* vAsk);
    void process();
};

#endif

