################################################################################
#                                                                              #
#    Ambient Lights Test Client                                                #
#                                                                              #
#    Copyright 2012 Robert Mai                                                 #
#                                                                              #
#    Contact: robert@hsapps.com                                                #
#    URL:     http://www.hsapps.com                                            #
#                                                                              #
#                                                                              #
#    Ambient Lights Test Client is free software: you can                      #
#    redistribute it and/or modify it under the terms of the GNU General       #
#    Public License as published by the Free Software Foundation, either       #
#    version 3 of the License, or (at your option) any later version.          #
#                                                                              #
#    Ambient Lights Test Client is distributed in the hope that                #
#    it will be useful, but WITHOUT ANY WARRANTY; without even the implied     #
#    warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.          #
#    See the GNU General Public License for more details.                      #
#                                                                              #
#    You should have received a copy of the GNU General Public License         #
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.     #
#                                                                              #
################################################################################

from wx import *

import thread,Queue,serial

class MainFrame(wx.Frame):
    def __init__(self):
        wx.Frame.__init__(self,None, -1, "ColorChooser")
        
        self.Q = Queue.Queue()
        self.Serial = None
        self.__buildFrame()
        self.__setBindings()
        
    def __buildScaler(self,sizer,caption):
        sizer.Add(wx.StaticText(self.Panel,wx.ID_ANY,caption),flag=wx.ALIGN_CENTER)
        sizer.Add(wx.StaticText(self.Panel,wx.ID_ANY,"255"),flag=wx.ALIGN_CENTER)
        slider = wx.Slider(self.Panel,wx.ID_ANY,style=wx.SL_VERTICAL,value=127,minValue=0,maxValue=255)
        sizer.Add(slider,1,flag=wx.ALIGN_CENTER)
        sizer.Add(wx.StaticText(self.Panel,wx.ID_ANY,"0"),flag=wx.ALIGN_CENTER)
        value_label = wx.StaticText(self.Panel,wx.ID_ANY,"128")
        ft = value_label.GetFont()
        ft.SetWeight(wx.FONTWEIGHT_BOLD)
        value_label.SetFont(ft)
        sizer.Add(value_label,flag=wx.ALIGN_CENTER)
        return slider,value_label
        
        
        
    def __buildFrame(self):
        self.Panel = wx.Panel(self, -1, style = wx.NO_BORDER)
        
        self.MainSizer = wx.BoxSizer(wx.VERTICAL)
        
        self.SettingsSizer = wx.BoxSizer(wx.HORIZONTAL)
        
        self.SpeedSizer = wx.BoxSizer(wx.HORIZONTAL)

        self.VerboseSizer = wx.BoxSizer(wx.HORIZONTAL)
        
        self.BottomSizer = wx.BoxSizer(wx.HORIZONTAL)
        
        self.RedSizer = wx.BoxSizer(wx.VERTICAL)
        self.GreenSizer = wx.BoxSizer(wx.VERTICAL)
        self.BlueSizer = wx.BoxSizer(wx.VERTICAL)
        self.BrightSizer = wx.BoxSizer(wx.VERTICAL)
        
        self.MainSizer.Add(self.SettingsSizer,0,flag=wx.EXPAND)
        self.MainSizer.Add(self.SpeedSizer,0,flag=wx.EXPAND)
        self.MainSizer.Add(self.VerboseSizer,0,flag=wx.EXPAND)
        
        self.BottomSizer.Add(self.RedSizer,1,flag=wx.EXPAND)
        self.BottomSizer.Add(self.GreenSizer,1,flag=wx.EXPAND)
        self.BottomSizer.Add(self.BlueSizer,1,flag=wx.EXPAND)
        self.BottomSizer.Add(self.BrightSizer,1,flag=wx.EXPAND)
        
        self.MainSizer.Add(self.BottomSizer,1,flag=wx.EXPAND)
        
        
        #build elements:
        self.SettingsSizer.Add(wx.StaticText(self.Panel,wx.ID_ANY,"COM:"))
        self.TC_Port = wx.TextCtrl(self.Panel,wx.ID_ANY,"3")
        self.SettingsSizer.Add(self.TC_Port)
        self.B_Connect = wx.Button(self.Panel, wx.ID_ANY, "Connect")
        self.SettingsSizer.Add(self.B_Connect)
        self.B_Auto = wx.Button(self.Panel, wx.ID_ANY, "Auto")
        self.SettingsSizer.Add(self.B_Auto)
        self.B_Hold = wx.Button(self.Panel, wx.ID_ANY, "Hold")
        self.SettingsSizer.Add(self.B_Hold)
        
        self.SpeedSizer.Add(wx.StaticText(self.Panel,wx.ID_ANY,"Color change speed:  min:"))
        self.TC_MinSpeed = wx.TextCtrl(self.Panel,wx.ID_ANY,"1")
        self.SpeedSizer.Add(self.TC_MinSpeed)
        self.SpeedSizer.Add(wx.StaticText(self.Panel,wx.ID_ANY,"max:"))
        self.TC_MaxSpeed = wx.TextCtrl(self.Panel,wx.ID_ANY,"5")
        self.SpeedSizer.Add(self.TC_MaxSpeed)
        self.B_Speed = wx.Button(self.Panel, wx.ID_ANY, "Set")
        self.SpeedSizer.Add(self.B_Speed)
        
        self.B_VerboseOn = wx.Button(self.Panel, wx.ID_ANY, "Verbose ON")
        self.B_VerboseOff = wx.Button(self.Panel, wx.ID_ANY, "Verbose OFF")
        self.VerboseSizer.Add(self.B_VerboseOn)
        self.VerboseSizer.Add(self.B_VerboseOff)
        
        self.RedSlider,self.RedLabel = self.__buildScaler(self.RedSizer, "R")
        self.GreenSlider,self.GreenLabel = self.__buildScaler(self.GreenSizer, "G")
        self.BlueSlider,self.BlueLabel = self.__buildScaler(self.BlueSizer, "B")
        self.BrightSlider,self.BrightLabel = self.__buildScaler(self.BrightSizer, "Bright")
        
        self.ColorLabel = wx.StaticText(self.Panel,wx.ID_ANY,"  ")
        self.MainSizer.Add(self.ColorLabel,0,flag=wx.EXPAND)
        
        
        
        
        self.Panel.SetSizer(self.MainSizer)
        self.MainSizer.SetSizeHints(self.Panel)
        
        self.onColorSliderChange()
        self.onBrightSliderChange()
        
    def __setBindings(self):
        self.RedSlider.Bind(wx.EVT_SLIDER,self.onColorSliderChange)
        self.GreenSlider.Bind(wx.EVT_SLIDER,self.onColorSliderChange)
        self.BlueSlider.Bind(wx.EVT_SLIDER,self.onColorSliderChange)
        self.BrightSlider.Bind(wx.EVT_SLIDER,self.onBrightSliderChange)
        
        self.B_Connect.Bind(wx.EVT_BUTTON,self.onConnect)
        self.B_Auto.Bind(wx.EVT_BUTTON,self.onAuto)
        self.B_Hold.Bind(wx.EVT_BUTTON,self.onHold)
        self.B_Speed.Bind(wx.EVT_BUTTON, self.onSpeed)
        
        self.B_VerboseOn.Bind(wx.EVT_BUTTON, self.onVerboseOn)
        self.B_VerboseOff.Bind(wx.EVT_BUTTON, self.onVerboseOff)
    
    def onVerboseOn(self,evt=None):
        self.send("v001")
        
    def onVerboseOff(self,evt=None):
        self.send("v000")
        
    def onColorSliderChange(self,evt=None):
        self.RedLabel.SetLabel(str(255-self.RedSlider.GetValue()))
        self.GreenLabel.SetLabel(str(255-self.GreenSlider.GetValue()))
        self.BlueLabel.SetLabel(str(255-self.BlueSlider.GetValue()))
        self.refreshColors()

    def onBrightSliderChange(self,evt=None):
        self.BrightLabel.SetLabel(str(255-self.BrightSlider.GetValue()))
        self.refreshColors(True)
        self.send("b" + self.formatNumber(255-self.BrightSlider.GetValue()))
        
    
    def refreshColors(self,donotsend=False):
        r = 255-self.RedSlider.GetValue()
        g = 255-self.GreenSlider.GetValue()
        b = 255-self.BlueSlider.GetValue()
        br = 255-self.BrightSlider.GetValue()
        
        self.ColorLabel.SetBackgroundColour(wx.Colour(int(r * br/255),int(g * br/255),int(b * br/255)))
        self.ColorLabel.Refresh()
        if not donotsend:
            self.send("c"+self.formatNumber(r)+self.formatNumber(g)+self.formatNumber(b))
    
    def onConnect(self,evt):
        port = int(self.TC_Port.GetValue())
        print "opening COM port", port
        self.Serial = serial.Serial(port = port-1, baudrate=19200)

        thread.start_new_thread(self.__ComThread, ())
        thread.start_new_thread(self.__ComRcvThread, ())
    
    def onAuto(self,evt):
        self.send("a")

    def onHold(self,evt):
        self.send("h")
    
    def onSpeed(self,evt):
        self.send("s" + self.formatNumber(int(self.TC_MinSpeed.GetValue())) + self.formatNumber(int(self.TC_MaxSpeed.GetValue())))
    
    def formatNumber(self,i):
        if i > 999:
            return "999"
        if i < 0:
            return "000"
        res = str(i)
        while len(res)<3:
            res = "0" + res
        return res
    
    def send(self,s):
        self.Q.put(s)
    
    def __ComRcvThread(self):
        while True:
            l = self.Serial.readline()
            print l
    
    def __ComThread(self):
        #self.Serial.open()
        while True:
            s = self.Q.get(True, None)
            print "send:",s
            self.Serial.write(s)
            
    
    
class MyApp(wx.App):
    def OnInit(self):
        frame = MainFrame()
        frame.Show(True)
        self.SetTopWindow(frame)
        return True

if __name__ == "__main__":
    app = MyApp(0)
    app.MainLoop()
