/*
################################################################################
#                                                                              #
#    Ambient Lights Controller Firmware                                        #
#                                                                              #
#    Copyright 2012 Robert Mai                                                 #
#                                                                              #
#    Contact: robert@hsapps.com                                                #
#    URL:     http://www.hsapps.com                                            #
#                                                                              #
#                                                                              #
#    Ambient Lights Controller Firmware is free software: you can              #
#    redistribute it and/or modify it under the terms of the GNU General       #
#    Public License as published by the Free Software Foundation, either       #
#    version 3 of the License, or (at your option) any later version.          #
#                                                                              #
#    Ambient Lights Controller Firmware is distributed in the hope that        #
#    it will be useful, but WITHOUT ANY WARRANTY; without even the implied     #
#    warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.          #
#    See the GNU General Public License for more details.                      #
#                                                                              #
#    You should have received a copy of the GNU General Public License         #
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.     #
#                                                                              #
################################################################################
*/

#ifndef EncoderButton_h
#define EncoderButton_h

#include "WProgram.h"

#define BUTTON_RIGHT 1
#define BUTTON_LEFT  -1

#define BUTTON_DOWN 0
#define BUTTON_UP 1

#define DEBOUNCE_TIME_MS 10

class EncoderButton
{
  private:
    int PIN_BTN_A;
    int PIN_BTN_B;
    int PIN_BTN_BTN;
    unsigned long BUTTON_LONG_TIME;
    int valA;
    int valB;
    int valBTN;
    int newA;
    int newB;
    int newBTN;
    unsigned long previousMillisA;
    unsigned long previousMillisB;
    unsigned long previousMillisBtn;
    int btnDirection;
    boolean btnClickInterfered;
    unsigned long btnDownTime;
    int debounce(int newVal, int oldVal, unsigned long currentMillis, unsigned long *previousMillis);
  public:
    EncoderButton();
    void setup(int pinA, int pinB, int pinBtn, unsigned long longClickTime);
    void process();
    
    boolean evtButton; //some event happened
    boolean evtButtonClick; //button was pressed w/o turning between down and up
    boolean evtButtonLongClick; //button was long pressed w/o turning between down and up
    boolean evtButtonDownRight; //button was turned right while pushed
    boolean evtButtonDownLeft; //button was turned left while pushed
    boolean evtButtonRight; //button was turned right w/o being pushed
    boolean evtButtonLeft; //button was turned left w/o being pushed
};

#endif

