/*
################################################################################
#                                                                              #
#    Ambient Lights Controller Firmware                                        #
#                                                                              #
#    Copyright 2012 Robert Mai                                                 #
#                                                                              #
#    Contact: robert@hsapps.com                                                #
#    URL:     http://www.hsapps.com                                            #
#                                                                              #
#                                                                              #
#    Ambient Lights Controller Firmware is free software: you can              #
#    redistribute it and/or modify it under the terms of the GNU General       #
#    Public License as published by the Free Software Foundation, either       #
#    version 3 of the License, or (at your option) any later version.          #
#                                                                              #
#    Ambient Lights Controller Firmware is distributed in the hope that        #
#    it will be useful, but WITHOUT ANY WARRANTY; without even the implied     #
#    warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.          #
#    See the GNU General Public License for more details.                      #
#                                                                              #
#    You should have received a copy of the GNU General Public License         #
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.     #
#                                                                              #
################################################################################
*/

#ifndef StateMachine_h
#define StateMachine_h

#include "Arduino.h"

#include "LEDController.h"

#define STATE_MANUAL_MIN 0
#define STATE_MANUAL_HUE 0
#define STATE_MANUAL_SATURATION 1
#define STATE_MANUAL_VALUE 2
#define STATE_MANUAL_MAX 2
//MANUAL STATES MUST STAY IN THIS ORDER!!!

#define STATE_AUTO 3

#define EVENT_CLICK 0
#define EVENT_LONG_CLICK 1
#define EVENT_RIGHT 2
#define EVENT_LEFT 3
#define EVENT_DOWN_RIGHT 4
#define EVENT_DOWN_LEFT 5


#define AUTO_STEP_SIZE 1
#define AUTO_DELAY 20


class StateMachine
{
  private:
    LEDController* led;
    byte state;
    int delta;
    int bigDelta;
    unsigned long autoNextStep;
    int autoStepSize; //Step size during auto hue
    int autoDelay; //delay until next hue step will be made
    
    void increaseAutoSpeed(boolean largeStep);
    void decreaseAutoSpeed(boolean largeStep);
  public:
    StateMachine();
    void setup(LEDController* vLed, int vDelta, int vBigDelta);
    void resetAutoSpeed(); //resets auto speed values
    void onEvent(byte event); //processes button events
    void onSetRGB(int vR, int vG, int vB); //called by serial interface
    void onSetHSV(int vH, int vS, int vV); //called by serial interface
    void onSetAuto(boolean active); //called by serial interface
    void onSetAutoValues(int stepSize, int stepDelay); //called by serial interface
    void process();
    void setState(byte state);
    byte getState();
    void printState();
    int getAutoStepSize();
    int getAutoDelay();
    void synchronize(StateMachine* source); //synchronize with source's values
};

#endif

