/*
################################################################################
#                                                                              #
#    Ambient Lights Controller Firmware                                        #
#                                                                              #
#    Copyright 2012 Robert Mai                                                 #
#                                                                              #
#    Contact: robert@hsapps.com                                                #
#    URL:     http://www.hsapps.com                                            #
#                                                                              #
#                                                                              #
#    Ambient Lights Controller Firmware is free software: you can              #
#    redistribute it and/or modify it under the terms of the GNU General       #
#    Public License as published by the Free Software Foundation, either       #
#    version 3 of the License, or (at your option) any later version.          #
#                                                                              #
#    Ambient Lights Controller Firmware is distributed in the hope that        #
#    it will be useful, but WITHOUT ANY WARRANTY; without even the implied     #
#    warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.          #
#    See the GNU General Public License for more details.                      #
#                                                                              #
#    You should have received a copy of the GNU General Public License         #
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.     #
#                                                                              #
################################################################################
*/

#include <MyHomeMessageLayer.h>

#include <EEPROM.h>

//#include <Ports.h>
//#include <RF12.h>

#include <ASKModulator.h>


#include "EncoderButton.h"
#include "LEDController.h"
#include "StateMachine.h"
#include "SerialMessageInterface.h"
#include "StateSaver.h"


#define PIN_BTN_A 2
#define PIN_BTN_B 1
#define PIN_BTN_BTN 0



//First RGB channel
#define PIN_1_RED   3
#define PIN_1_GREEN 5
#define PIN_1_BLUE  6


//Second RGB channel:
#define PIN_2_RED   10
#define PIN_2_GREEN 11
#define PIN_2_BLUE  9

#define BUTTON_LONG_TIME 1000

#define DELTA 1
#define BIG_DELTA 20

#define SERIAL_BAUD_RATE 19200

#define FADE_DELAY 500

EncoderButton btn;

//Instances for channel 1:
LEDController led1;
StateMachine sm1;

//Instances for channel 2:
LEDController led2;
StateMachine sm2;

SerialMessageInterface si;

StateSaver ss;


//ASKModulator askMod;


void setup()  {
  btn.setupAnalog(PIN_BTN_A,PIN_BTN_B,PIN_BTN_BTN,BUTTON_LONG_TIME);

  led1.setup(PIN_1_RED,PIN_1_GREEN,PIN_1_BLUE);
  sm1.setup(&led1,DELTA,BIG_DELTA);
  
  led2.setup(PIN_2_RED,PIN_2_GREEN,PIN_2_BLUE);
  sm2.setup(&led2,DELTA,BIG_DELTA);
  
  
  si.setup(SERIAL_BAUD_RATE,&sm1,&led1,&sm2,&led2); //,NULL);
  ss.setup(&led1,&led2);
  
  //RF12 stuff:
//  askMod.setFunctions(&askHigh,&askLow,NULL,NULL);
//  rf12_initialize(0, RF12_433MHZ, 0);


  led1.setRGB(50,0,0);
  led2.setRGB(0,50,0);
  ss.readState(FADE_DELAY);
  led1.refreshLEDs();
  led2.refreshLEDs();
}

void loop() {
  si.process();
  btn.process();
  byte oldState = sm1.getState();
  
  if (btn.evtButton)
  {
    //using the button makes channel2 do the same as channel1!
    // -> synchronize sm2 to sm1's values.
    if (btn.evtButtonLongClick)
      sm1.onEvent(EVENT_LONG_CLICK);
    if (btn.evtButtonClick)
      sm1.onEvent(EVENT_CLICK);
    if (btn.evtButtonDownLeft)
      sm1.onEvent(EVENT_DOWN_LEFT);
    if (btn.evtButtonDownRight)
      sm1.onEvent(EVENT_DOWN_RIGHT);
    if (btn.evtButtonLeft)
      sm1.onEvent(EVENT_LEFT);
    if (btn.evtButtonRight)
      sm1.onEvent(EVENT_RIGHT);

    if (sm1.getState() != oldState)
    {
      oldState = sm1.getState();
      if (oldState == STATE_MANUAL_HUE)
        led1.forceRGB(255,0,0,250);
      else if (oldState == STATE_MANUAL_SATURATION)
        led1.forceRGB(0,255,0,250);
      else if (oldState == STATE_MANUAL_VALUE)
        led1.forceRGB(0,0,255,250);
    }
    sm2.synchronize(&sm1);
  }
  led1.process();
  led2.process();
  sm1.process();
  sm2.process();
  ss.process();
}

/*
//RF12 ASK stuff:
void askHigh() {
  rf12_onOff(true);
}

void askLow() {
  rf12_onOff(false);
}
*/
