/*
################################################################################
#                                                                              #
#    Ambient Lights Controller Firmware                                        #
#                                                                              #
#    Copyright 2012 Robert Mai                                                 #
#                                                                              #
#    Contact: robert@hsapps.com                                                #
#    URL:     http://www.hsapps.com                                            #
#                                                                              #
#                                                                              #
#    Ambient Lights Controller Firmware is free software: you can              #
#    redistribute it and/or modify it under the terms of the GNU General       #
#    Public License as published by the Free Software Foundation, either       #
#    version 3 of the License, or (at your option) any later version.          #
#                                                                              #
#    Ambient Lights Controller Firmware is distributed in the hope that        #
#    it will be useful, but WITHOUT ANY WARRANTY; without even the implied     #
#    warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.          #
#    See the GNU General Public License for more details.                      #
#                                                                              #
#    You should have received a copy of the GNU General Public License         #
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.     #
#                                                                              #
################################################################################
*/

#ifndef LEDController_h
#define LEDController_h

#include "Arduino.h"

#define HUE_MIN 0
#define HUE_MAX 360
#define SATURATION_MIN 0
#define SATURATION_MAX 255
#define VALUE_MIN 0
#define VALUE_MAX 255

class LEDController
{
  private:
    int pinR;
    int pinG;
    int pinB;
    
    int hue; // 0..360
    int saturation; // 0..255
    int value; // 0..255
    
    int r;
    int g;
    int b;
    
    int forceR;
    int forceG;
    int forceB;
    boolean forceOn;
    unsigned long forceTargetTime;
    
    void hsvToRGB();
    void rgbToHSV();
    void setRGBHelper(float vR, float vG, float vB);
  public:
    LEDController();
    void setup(int pinR, int pinG, int pinB);
    void process();
    void refreshLEDs();

    void forceRGB(int vR, int vG, int vB, unsigned long duration);
    void forceHSV(int vH, int vS, int vV, unsigned long duration);
    
    void setHSV(int vH, int vS, int vV);
    void setHue(int value);
    void setSaturation(int value);
    void setValue(int value);
    int getHue();
    int getSaturation();
    int getValue();
    int getR();
    int getG();
    int getB();
    void setRGB(int vR, int vG, int vB);
    void synchronize(LEDController* source);
};

#endif

