/*
################################################################################
#                                                                              #
#    Ambient Lights Controller Firmware                                        #
#                                                                              #
#    Copyright 2012 Robert Mai                                                 #
#                                                                              #
#    Contact: robert@hsapps.com                                                #
#    URL:     http://www.hsapps.com                                            #
#                                                                              #
#                                                                              #
#    Ambient Lights Controller Firmware is free software: you can              #
#    redistribute it and/or modify it under the terms of the GNU General       #
#    Public License as published by the Free Software Foundation, either       #
#    version 3 of the License, or (at your option) any later version.          #
#                                                                              #
#    Ambient Lights Controller Firmware is distributed in the hope that        #
#    it will be useful, but WITHOUT ANY WARRANTY; without even the implied     #
#    warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.          #
#    See the GNU General Public License for more details.                      #
#                                                                              #
#    You should have received a copy of the GNU General Public License         #
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.     #
#                                                                              #
################################################################################
*/

#include <EEPROM.h>

#include "EncoderButton.h"
#include "LEDController.h"
#include "StateMachine.h"
#include "SerialInterface.h"
#include "StateSaver.h"

#define PIN_BTN_A 7
#define PIN_BTN_B 4
#define PIN_BTN_BTN 8

#define PIN_RED 3
#define PIN_GREEN 5
#define PIN_BLUE 6

#define PIN_RED_2 11
#define PIN_GREEN_2 10
#define PIN_BLUE_2 9

#define BUTTON_LONG_TIME 1000

#define DELTA 1
#define BIG_DELTA 20

#define SERIAL_BAUD_RATE 19200

#define FADE_DELAY 500

EncoderButton btn;
LEDController led;
StateMachine sm;
SerialInterface si;

StateSaver ss;

void setup()  {
  btn.setup(PIN_BTN_A,PIN_BTN_B,PIN_BTN_BTN,BUTTON_LONG_TIME);
  led.setup(PIN_RED,PIN_GREEN,PIN_BLUE);
  sm.setup(&led,DELTA,BIG_DELTA);
  si.setup(SERIAL_BAUD_RATE,&sm,&led);
  ss.setup(&led);
  
  led.setHSV(56,255,255);
  ss.readState(FADE_DELAY);
  led.refreshLEDs();
}

void loop() {
  si.process();
  btn.process();
  byte oldState = sm.getState();
  
  if (btn.evtButton)
  {
    if (btn.evtButtonLongClick)
      sm.onEvent(EVENT_LONG_CLICK);
    if (btn.evtButtonClick)
      sm.onEvent(EVENT_CLICK);
    if (btn.evtButtonDownLeft)
      sm.onEvent(EVENT_DOWN_LEFT);
    if (btn.evtButtonDownRight)
      sm.onEvent(EVENT_DOWN_RIGHT);
    if (btn.evtButtonLeft)
      sm.onEvent(EVENT_LEFT);
    if (btn.evtButtonRight)
      sm.onEvent(EVENT_RIGHT);
  }
  if (sm.getState() != oldState)
  {
    oldState = sm.getState();
    if (oldState == STATE_MANUAL_HUE)
      led.forceRGB(255,0,0,250);
    else if (oldState == STATE_MANUAL_SATURATION)
      led.forceRGB(0,255,0,250);
    else if (oldState == STATE_MANUAL_VALUE)
      led.forceRGB(0,0,255,250);
  }
  led.process();
  sm.process();
  ss.process();
}
