/*
################################################################################
#                                                                              #
#    Ambient Lights Controller Firmware                                        #
#                                                                              #
#    Copyright 2012 Robert Mai                                                 #
#                                                                              #
#    Contact: robert@hsapps.com                                                #
#    URL:     http://www.hsapps.com                                            #
#                                                                              #
#                                                                              #
#    Ambient Lights Controller Firmware is free software: you can              #
#    redistribute it and/or modify it under the terms of the GNU General       #
#    Public License as published by the Free Software Foundation, either       #
#    version 3 of the License, or (at your option) any later version.          #
#                                                                              #
#    Ambient Lights Controller Firmware is distributed in the hope that        #
#    it will be useful, but WITHOUT ANY WARRANTY; without even the implied     #
#    warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.          #
#    See the GNU General Public License for more details.                      #
#                                                                              #
#    You should have received a copy of the GNU General Public License         #
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.     #
#                                                                              #
################################################################################
*/

#ifndef SerialInterface_h
#define SerialInterface_h

#include "WProgram.h"
#include "StateMachine.h"
#include "LEDController.h"

//interface's version number. must be positive int.
#define SERIAL_INTERFACE_VERSION 1

class SerialInterface
{
  private:
    StateMachine* sm;
    LEDController* led;
    int receiveIntValue();
    int VERBOSE;
  public:
    SerialInterface();
    void setup(int baudRate, StateMachine* vSm, LEDController* vLed);
    void process();
};

#endif

